CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_cupomfiscal_pbm') THEN 
		DROP VIEW public.v_cupomfiscal_pbm;
		RAISE NOTICE 'v_cupomfiscal_pbm Dropada.';
	END IF;

	CREATE OR REPLACE VIEW public.v_cupomfiscal_pbm AS
	 SELECT vd.cd_emp,
		vd.cd_filial,
		vd.dt_vd,
		vd.dt_cad,
		vd.cd_cx,
		vd.cd_vd,
		vd.nr_ecf,
		vd.st_vd,
		vd.cd_conv,
			CASE
				WHEN vd.tipo_pbm::numeric > 0::numeric THEN
				CASE
					WHEN vd.cd_cli_pbm = 0::numeric THEN ( SELECT rc_cli.cd_cli
					   FROM rc_cli
					  WHERE rc_cli.rot_conv_ext = vd.tipo_pbm::numeric AND rc_cli.sts_cli = 0::numeric
					 LIMIT 1)
					ELSE vd.cd_cli_pbm
				END
				ELSE vd.cd_cli
			END AS cd_cli_conv,
		NULL::character varying AS cgc_conv,
		vd.tipo_pbm,
			CASE vd.tipo_pbm
				WHEN 1 THEN 'prevsaude'::character varying
				WHEN 2 THEN 'vida-link'::character varying
				WHEN 3 THEN 'e-pharma'::character varying
				WHEN 4 THEN 'transaction center'::character varying
				WHEN 5 THEN 'farmacia popular'::character varying
				WHEN 6 THEN 'funcional card'::character varying
				ELSE 'outros'::character varying
			END AS nm_conv,
		vd.vlr_conv_pbm AS vlr_conv,
		COALESCE(it.nr_autorizacao_pbm, it.nr_orc_vd_link) AS cd_autorizacao,
		it.cd_it,
		it.cd_prod,
		it.vlr_avista_pbm AS vlr_prod_cli,
		COALESCE(
			CASE
				WHEN it.vlr_reembol_pbm = 0::numeric THEN NULL::numeric
				ELSE it.vlr_reembol_pbm
			END,
			CASE
				WHEN it.vlr_reembol = 0::numeric THEN NULL::numeric
				ELSE it.vlr_reembol
			END) AS vlr_prod_reembolso,
		it.vlr_conv_pbm AS vlr_prod_conv,
		COALESCE(cd_usu_libera_pos_pbm, 0) AS cd_usu_libera_pos_pbm,
		COALESCE(valor_desconto_pos_pbm, 0) AS valor_desconto_pos_pbm,
		COALESCE(vd.flag_consolidado, 0) AS flag_consolidado
	   FROM 
				pdv_vd vd
		 JOIN pdv_vd_it it ON vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd
	  WHERE vd.st_vd > '-1'::integer::numeric AND vd.tipo_pbm > 0 and (length(it.nr_autorizacao_pbm) > 1 or  length(it.nr_orc_vd_link) >1 );
	  
	RAISE NOTICE 'v_cupomfiscal_pbm Recriada.';
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();